<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Pricing_model extends My_Model
{
	public $primary_key = 'id';
	public $get_insurance_details = false;
	public $_table = 'pricing';
	public $before_delete = array( 'before_delete' );
	public $after_create = array( 'after_create' );
	public $after_update = array( 'after_update' );
	public $after_get = array( 'after_get' );
	public $after_get_allow = false;
	protected $CI;

	/*Pricing vars*/
	public $is_special_offer = false;
	public $pickup_date;
	public $pickup_time;
	public $dropoff_date;
	public $dropoff_time;
	public $pickup_location = 0;
	public $dropoff_location = 0;
	public $car_id;
	public $car_category;
	public $car_group;
	public $insuranceGroupId;
	public $booking_selected_facilities;
	public $booking_total_days;
	public $booking_selected_insurance;
	public $booking_user_age;
	public $booking_user_driveragenumber;
	public $per_day_price;
	public $per_day_special_offer_price;
	public $special_offer_price = 0;
	public $original_price = 0;
	public $coupon_applied_price = 0;	
	public $driver_age_price = 0;
	public $dropoff_price = 0;
	public $insurance_price = 0;
	/*Final price after all calculations*/
	public $total = 0;
	public $special_offer_id = 0;
	public $spacial_offer_percentage;
	public $additional_price;
	public $basic_price;
	public $advanced_price;
	/*Pricing vars*/
	public $validate = array(
		'categoryId'  => array(
			'field' => 'categoryId',
			'label' => 'Category',
			'rules' => 'trim|required|xss_clean',
			'error_msg' => array(
				'required'  => 'lang:CAR_CATEGORY_REQUIRED',				
				),
			)
		);
	public function __construct()
	{
		parent::__construct();
		$this->CI=& get_instance();
	}
	public function get_car_price()
	{
		$this->load->model("cars_model");
		$this->load->model("locations_fee_model");
		$response = array();
		$this->pickup_date = ($this->pickup_date != "") ? date('Y-m-d',strtotime($this->pickup_date)):"";
		$this->dropoff_date = ($this->dropoff_date != "") ? date('Y-m-d',strtotime($this->dropoff_date)):"";
		if($this->pickup_date != "" &&  $this->dropoff_date != "")
		{
			$date_diff_pickup_date = $this->pickup_date." ".$this->pickup_time.":00";
			$date_diff_dropoff_date = $this->dropoff_date." ".$this->dropoff_time.":00";
			$this->booking_total_days = date_difference($date_diff_pickup_date,$date_diff_dropoff_date);
			

		}
		else{
			$this->booking_total_days = 1;
		}
		$this->cars_model->after_get_allow=false;
		$car_data = $this->cars_model->get($this->car_id);
		if(!empty($car_data))
		{
			$this->car_group = $car_data["groupId"];
			$this->car_category = $car_data["categoryId"];
			/*Check for advacned price*/
			if($this->pickup_date && $this->dropoff_date)
			{
				$loopDate = date('m-d',strtotime($this->pickup_date));
				
				for($i=0;$i<$this->booking_total_days;$i++)
				{
					$advanced_price_check = $this->get_advanced_price($loopDate);
					/*var_dump($advanced_price_check);
					exit();*/
					if($advanced_price_check == false && $this->advanced_price == 0)
					{
						$basic_price_check = $this->get_basic_price();
						if($basic_price_check == true)
						{
							$this->total += $this->basic_price;
						}
					}
					else{
						$this->total += $this->advanced_price;
					}
					$loopDate = date('m-d',strtotime($this->pickup_date.' +1 day'));
					$this->basic_price = 0;
					$this->advanced_price = 0;
				}
			}
			else{
				$basic_price_check = $this->get_basic_price();
				if($basic_price_check == true)
				{
					$this->total += $this->basic_price;
				}
				$this->basic_price = 0; 
			}

			$this->original_price = $this->total;	
			$this->per_day_price=round($this->total/$this->booking_total_days,2);
			/*Check for advacned price*/

			if($this->total>0){
				/*Check for opposite special offer*/

				$check_special_offer_opposite_flag = $this->check_special_offer_opposite();
				if($check_special_offer_opposite_flag == true)
				{
					$this->total += $this->special_offer_price;								
				}
				else{
					$check_special_offer_flag = $this->check_special_offer();
					if($check_special_offer_flag == true)
					{
						$this->total -= $this->special_offer_price;
						$this->per_day_special_offer_price=round($this->total/$this->booking_total_days,2);
						$this->is_special_offer = true;
					}
				}

				/*Check for additional location based price*/
				if($this->pickup_location > 0 && $this->dropoff_location > 0)
				{
					$additional_location_price_where = array('fromId'=>$this->pickup_location,'toId'=>$this->dropoff_location);
					$check_for_additional_location_price = $this->locations_fee_model->get_by($additional_location_price_where);
					if(!empty($check_for_additional_location_price))
					{
						$this->dropoff_price = $check_for_additional_location_price["price"]; 
						$this->total += $this->booking_total_days*$check_for_additional_location_price["price"];
					}
				}
				/*Check for additional location based price ends*/


				/*Driver extra age charge*/
				$age_surcharge_status = $this->get_age_surcharge_price();

				if($age_surcharge_status == true)
				{
					$this->total += $this->driver_age_price;
				}


				/*Driver extra age charge*/

				/*working time surcharge needed to implement*/
				if($this->pickup_location>0){
					$pickup_location_details = $this->locations_model->get($this->pickup_location);
				}
				if($this->dropoff_location>0){
					$dropoff_location_details = $this->locations_model->get($this->dropoff_location);
				}


				if(!empty($pickup_location_details) && !empty($dropoff_location_details)) 
				{

					/*TIME_SURCHARGE_PRICE*/	
					if($this->pickup_time.":00" < $pickup_location_details["working_from"])
					{	
						$this->total += TIME_SURCHARGE_PRICE;
						$response["from_time_surcharge_price"] = TIME_SURCHARGE_PRICE;
					}

					if($this->dropoff_time.":00" > $dropoff_location_details["working_to"])
					{
						$this->total += TIME_SURCHARGE_PRICE;
						$response["to_time_surcharge_price"] = TIME_SURCHARGE_PRICE;
					}
				}

				/*working time surcharge needed to implement ends*/

				
				/*$this->per_day_total_price=round($this->total/$this->booking_total_days,2);
				$this->per_day_special_offer_total_price=round($this->total/$this->booking_total_days,2);*/

				/*Facilities pricing calculate*/
				$check_facilities_status = $this->get_facilities_price();
				/*Facilities pricing calculate*/

				/*Insurance Pricing*/			
				$check_insurance_status = $this->get_insurance_price();
				/*Insurance Pricing ends*/


				/*Apply coupon if applied*/
				$check_coupon_applied_flag = $this->apply_coupon_price($car_data);
				if($check_coupon_applied_flag == true)
				{
					$this->total -= $this->coupon_applied_price;
				}
				/*Apply coupon if applied*/

			}
			$response["per_day_price"] = $this->per_day_price;
			$response["per_day_special_offer_price"] = $this->per_day_special_offer_price;			
			$response["basic_price"] = $this->basic_price;
			$response["advanced_price"] = $this->advanced_price;
			$response["dropoff_price"] = $this->dropoff_price;			
			$response["original_price"] = $this->original_price;
			$response["total"] = $this->total;
			$response["special_offer_price"] = $this->special_offer_price;
			$response["is_special_offer"] = $this->is_special_offer;	
			$response["coupon_applied_price"] = $this->coupon_applied_price;
			$response["booking_total_days"] = $this->booking_total_days;
			$response["driver_age_price"] = $this->driver_age_price;
			$response["driver_age_price_default"] = SPECIAL_AGE_PRICE;
			$response["insurance_price"] = $this->insurance_price;
			$response["time_surcharge_price"] = TIME_SURCHARGE_PRICE;

			$this->per_day_price = 0;
			$this->basic_price = 0;
			$this->advanced_price = 0;
			$this->dropoff_price = 0;
			$this->original_price = 0;
			$this->total = 0;
			$this->special_offer_price = 0;
			$this->coupon_applied_price = 0;
			/*printr($response);*/
			return $response;

		}
		else{
			return false;
		}
	}

	public function get_advanced_price($loopDate)
	{

		$this->load->model("season_model");
		$all_seasons = $this->season_model->get_many_by("status",'y');

		if(!empty($all_seasons))
		{
			foreach ($all_seasons as $key => $value) 
			{
				$date1 = $value["start_month"]."-".$value["start_date"];
				$date2 = $value["end_month"]."-".$value["end_date"];
				$checkstatus = check_in_range($date1,$date2,$loopDate);
				if($checkstatus)
				{
					$season_id = $value["id"];
				}

			}
		}

		/*echo " Date ".$loopDate;
		echo " pick ".$this->pickup_date;
		echo " Cat ".$this->car_category;*/
		/*echo " Jem ".date('m-d',strtotime($this->pickup_date));*/
		$loopDate = date(date('Y').'-m-d',strtotime($loopDate));
		/*	echo " Loopdate ".$loopDate;*/
		$select_month = date("m",strtotime($loopDate));
		$select_date = date("d",strtotime($loopDate));
		$advanced_price_where[] = array('pricing.type="a" AND pricing.categoryId = "'.$this->car_category.'" AND rental_days.status="y" AND day_price.price > 0 AND rental_days.day <= "'.$this->booking_total_days.'"',null,false);
		
		$advanced_price_where[] = array("('".$select_month."' BETWEEN season.start_month  and season.end_month) AND ('".$select_date."' BETWEEN season.start_date AND season.end_date)",null,false);

		$advanced_price_data = $this->set_fields('pricing.*,day_price.price,CAST(season.start_month AS UNSIGNED) start_month,CAST(season.end_month AS UNSIGNED) as end_month,CAST(season.start_date AS UNSIGNED) as start_date,CAST(season.end_date AS UNSIGNED) as end_date')->join('day_price', 'pricing.id = day_price.pricingId',"left")->join('season','pricing.seasonId = season.id','left')->join('rental_days','day_price.dayId=rental_days.id','left')->order_by('ABS(cast(rental_days.day as signed)-"'.$this->booking_total_days.'")')->get_by($advanced_price_where); 
		if(!empty($advanced_price_data))
		{
			$this->advanced_price += $advanced_price_data["price"];
		}
		if($this->advanced_price > 0){
			return true;
		}
		return false;
	}

	public function get_basic_price()
	{	
		$basic_price_where = array();
		$basic_price_where[] = array('pricing.type="b" AND pricing.categoryId = "'.$this->car_category.'" AND rental_days.status="y" AND day_price.price > 0 AND rental_days.day <= "'.$this->booking_total_days.'"',null,false);
		$basic_price_data = $this->set_fields('pricing.*,day_price.price')->join('day_price', 'pricing.id = day_price.pricingId',"left")->join('rental_days','day_price.dayId=rental_days.id','left')->order_by('ABS(cast(rental_days.day as signed) - "'.$this->booking_total_days.'")')->limit(1,0)->get_by($basic_price_where); 
		/*echo "<pre>";
		var_dump($basic_price_data);*/
		if(!empty($basic_price_data))
		{
			$this->basic_price = $basic_price_data["price"];
			return true;
		}
		return false;
	}

	public function check_special_offer_opposite()
	{

		$this->load->model("special_offer_opposite_model");
		$special_offer_opposite_where[] = array("(('".$this->pickup_date."' BETWEEN start_date AND end_date) OR ('".$this->dropoff_date."' BETWEEN start_date AND end_date)) AND status='y' AND price > 0 AND categoryId = '".$this->car_category."'",null,false);

		$special_offer_opposite_exist_check = $this->special_offer_opposite_model->get_by($special_offer_opposite_where);
		if(!empty($special_offer_opposite_exist_check))
		{

			if($special_offer_opposite_exist_check["type"] == "a")
			{
				$this->special_offer_price = $special_offer_opposite_exist_check["price"];
			}else if($special_offer_opposite_exist_check["type"] == "p"){

				$this->special_offer_price = ($this->total * $special_offer_opposite_exist_check["price"])/100;
			}
			return true;

		}
		else{
			return false;
		}
	}

	public function check_special_offer()
	{
		$this->load->model("offers_model");
		$special_offer_where[] = array("(('".$this->pickup_date."' BETWEEN start_date AND end_date) OR ('".$this->dropoff_date."' BETWEEN start_date AND end_date))  AND  status='y' AND price > 0 AND groupId = '".$this->car_group."'",null,false);
		$special_offer_exist_check = $this->offers_model->get_by($special_offer_where);
		if(!empty($special_offer_exist_check))
		{
			if($special_offer_exist_check["type"] == "a")
			{
				$this->special_offer_price = $special_offer_exist_check["price"];
			}else if($special_offer_exist_check["type"] == "p"){

				$this->special_offer_price = ($this->total * $special_offer_exist_check["price"])/100;
			}
			return true;
		}
		else{
			return false;
		}
	}

	public function get_facilities_price()
	{
		if(!empty($this->booking_selected_facilities))
		{
			$this->load->model("car_facilities_model");
			$facilities_where[] = array('car_facilities.id IN ('.implode(",",$this->booking_selected_facilities).')',null,false);
			$get_facilities_data = $this->car_facilities_model->set_fields("car_facilities.*")->get_many_by($facilities_where);

			/*printr($get_facilities_data);*/

			if(!empty($get_facilities_data))
			{
				foreach ($get_facilities_data as $key => $value) 
				{
					/*check if this exist in free faciliity timing*/
					if(isset($value["is_promo_code"]) && $value["is_promo_code"] == "yes")
					{
						/*check is any amount need to be paid*/
						if($value["promo_code_type"] == 'a')
						{
							$this->total +=  $value["promo_code_price"];
						}
						else
						{
							$this->total += 0;
						}
						/*check if this exist in free faciliity timing ends*/
					}
					else
					{
						if($value["type"] == "m")
						{
							$post_value_check_quantity = $this->input->post("car_facilities")[$value['id']];
							if($value["daily_cost"] == 0)
							{
								$this->total += ($post_value_check_quantity * $value["price"]);
							}	
							else{
								$all_days_facilities_price = $this->booking_total_days*($post_value_check_quantity * $value["price"]);
								if($all_days_facilities_price > $value['maximum_cost']){
									$this->total += $value['maximum_cost'];
								}
								else{
									$this->total +=  $all_days_facilities_price;
								}
							}
						}
						else
						{
							if($value["daily_cost"] == 0)
							{
								$this->total += $value["price"];
							}	
							else{
								$all_days_facilities_price = $this->booking_total_days*$value["price"];
								if($all_days_facilities_price > $value['maximum_cost']){
									$this->total += $value['maximum_cost'];
								}
								else{
									$this->total +=  $all_days_facilities_price;
								}
							}	
						}
					}


					/*printr($value);*/
					
				}
				return true;
			}
		}
		else{
			return false;
		}
	}


	public function get_insurance_price()
	{	
		if($this->insuranceGroupId > 0)
		{
			$this->load->model("category_insurance_price_model");
			$inusrance_where[] = array('groupId = "'.$this->insuranceGroupId.'" AND categoryId = "'.$this->car_category.'"',null,false);
			$get_insurance_data = $this->category_insurance_price_model->set_fields("category_insurance_price.*")->get_by($inusrance_where);

			if(!empty($get_insurance_data))
			{
				$all_days_insurance_price = $this->booking_total_days*$get_insurance_data["price"];
				if($all_days_insurance_price > $get_insurance_data['max_price']){
					$this->insurance_price = $get_insurance_data['max_price'];
					$this->total += $get_insurance_data['max_price'];
				}
				else{
					$this->insurance_price = $all_days_insurance_price;
					$this->total +=  $all_days_insurance_price;
				}				
				return true;
			}
		}
		else{
			return false;
		}
	}


	public function get_age_surcharge_price()
	{	
		
		if($this->booking_user_age===0 && $this->booking_user_driveragenumber < DRIVER_MINIMUM_AGE && $this->booking_user_driveragenumber > USER_MINIMUM_AGE){
			$special_age_price = (int)SPECIAL_AGE_PRICE;
			$this->driver_age_price = 0;
			$this->driver_age_price += $this->booking_total_days*$special_age_price;
			return true;
		}		
		else{
			return false;
		}
	}

	public function apply_coupon_price($car_data = null){
		$coupon_id = $this->session->userdata("coupon_id");
		if(!empty($car_data) && $coupon_id > 0)
		{	
			$this->load->model("coupons_model");
			$this->load->model("coupons_car_details_model");
			$coupon_data = $this->coupons_model->get($coupon_id);
			if(!empty($coupon_data["db_sel_cars"]))
			{
				$db_sel_cars_id = array();
				foreach ($coupon_data["db_sel_cars"] as $key => $value) {
					$db_sel_cars_id[] = $value["carId"];		
				}
			}
			/*printr($db_sel_cars_id);
			echo $this->car_id;*/
			if(in_array($this->car_id, $db_sel_cars_id))
			{
				if($this->total >= $coupon_data["minimum_total"])
				{
					if($coupon_data["type"] == 1)
					{
						$this->coupon_applied_price = $coupon_data["value"];
					}else if($coupon_data["type"] == 0){

						$this->coupon_applied_price = ($this->total * $coupon_data["value"])/100;
					}	
				}
			}
			return true;
		}
		else{
			return false;
		}
	}

	public function before_delete($data)
	{
		if(!$this->current_session)
		{	
			$data['before_return']['msg']=lang(INVALID_REQUEST);				
		}
		return $data;
	}

	public function after_get($data){
		if(!empty($data) && $this->after_get_allow==true)
		{
			$this->load->model("categories_model");
			$this->load->model("season_model");
			$this->load->model("day_price_model");
			if($data["categoryId"] > 0)
			{
				$cat_ar = $this->categories_model->set_fields("category")->get($data["categoryId"]);
				$data["category"] = $cat_ar["category"];
			}
			if($data["seasonId"] > 0)
			{
				$cat_ar = $this->season_model->set_fields("season_name")->get($data["seasonId"]);
				$data["season"] = $cat_ar["season_name"];
			}
			else{
				$data["season"] = "Start From";	
			}
			$pricing_ar = $this->day_price_model->get_many_by('pricingId',$data["id"]);
			if(!empty($pricing_ar))
			{
				$final_pricing_ar = array();
				foreach ($pricing_ar as $key => $value) {
					$final_pricing_ar[$value["dayId"]] = $value["price"];
				}
				$data["pricing_ar"] = $final_pricing_ar;
			}
		}
		return $data;
	}

	public function after_create($priceiId,$data)
	{
		if($data["type"])
		{
			$days_val = $this->input->post("rental_days");
			$pricing_day_data = array();
			if(!empty($days_val))
			{
				$i = 0;
				foreach ($days_val as $key => $value) {
					if($value["price"] > 0)
					{
						$pricing_day_data[$i]["pricingId"] = $priceiId;
						$pricing_day_data[$i]["dayId"] = $key;
						$pricing_day_data[$i]["price"] = $value["price"];
						$i++;	
					}
				}
				if(!empty($pricing_day_data))
				{
					$this->load->model("day_price_model");
					$this->day_price_model->insert_many($pricing_day_data,true);
				}
			}
		}		
		return $priceiId;
	}

	public function after_update($data,$updateId){
		$data = $data[0];
		$upd_status = $data[1];
		if($data["type"])
		{
			$this->load->model("day_price_model");
			$days_val = $this->input->post("rental_days");
			$pricing_day_data = array();
			if(!empty($days_val))
			{
				foreach ($days_val as $key => $value) {
					if($value["price"] > 0)
					{
						$temp =   array(
							'pricingId' => $updateId,
							'dayId'        => $key,
							'price'          => $value['price']
							);
						$exist_check_ar = array("pricingId"=>$updateId,"dayId"=>$key);
						$rec_exist_check = $this->day_price_model->get_by($exist_check_ar);
						if(!empty($rec_exist_check))
						{
							$this->day_price_model->update($rec_exist_check["id"],$temp,true);
						}else{
							$this->day_price_model->insert($temp,true);
						}
					}
					else{
						$delete_ar = array("pricingId"=>$updateId,"dayId"=>$key);
						$this->day_price_model->delete_by($delete_ar);
					}
				}
			}
		}
		return $upd_status;
	}
}
